function [Plda_scores, Lab_test, Gun_pairs] = plda_twoCov_test1(model, entest_data,entest_labels,opt)

% model : trained plda two covariance model
% entest_data : enrolment and test feature matrix of the form n x p where n
%               represents the number of datapoints and p represents the
%               number of features
% entest_labels : enrolment and test datapoint labels of the form nx1
% opt : takes values 1,2 and 3 - 1 for 1v1, 2 for 1v3 and 3 for 1v9



addpath('C:\Users\basun\Documents\MATLAB\CartC\Parallel\functions_parallel\two-cov\');
rng(0);
plda_scores=[];L_test=[]; gun_pair1=[]; gun_pair2=[];

uEntestLabs=unique(entest_labels); % the different guns in the enrol/test dataset

% need to divide entest data to enrol and test data
if opt==1
    Gun_t=[];
    
    parfor (dd=1:(size(entest_data,1)-1),29)
        % test dataset and labels
        enrol_data=entest_data(dd,:);
        enrol_labels=entest_labels(dd);
        
        % enrolment dataset and labels
        %idxT=setdiff(1:size(entest_data,1),dd);
        idxT=(dd+1):size(entest_data,1);
        test_data=entest_data(idxT,:);
        test_labels=entest_labels(idxT);
        
        scores = two_cov_verification(model, enrol_data, test_data);
        scores=scores';
        plda_scores=[plda_scores;scores];
        
        L_te=[]; gun_pair=[];
        % Same =1 , Different=0;
        for  g=1:length(test_labels)
            if test_labels(g)==enrol_labels
                L_te(g,1)=1;
            else
                L_te(g,1)=0;
            end
            gun_pair(g,1)=enrol_labels;
            gun_pair(g,2)=test_labels(g);
        end
        L_test=[L_test; L_te];
        Gun_t=[Gun_t;gun_pair];
        
    end
    gun_pair1=Gun_t(:,1);
    gun_pair2=Gun_t(:,2);
elseif opt ==2  % this is for 1v3
   for dd=1:size(entest_data,1)
        
        % test data and label
        test_data=entest_data(dd,:);
        test_labels=entest_labels(dd);
        
        % enrolment data and label
        idxT=setdiff(1:size(entest_data,1),dd);
        enrol_data_all=entest_data(idxT,:);
        enrol_labels_all=entest_labels(idxT);
        
        aa=randperm(size(enrol_data_all,1)); % randomise order of data points in the enrolment dataset
            
    enrol_data_all=enrol_data_all(aa,:);
        enrol_labels_all= enrol_labels_all(aa);
    
    [GroupId,~,index_j]=unique(enrol_labels_all);
     T=arrayfun(@(y) enrol_data_all(index_j==y,:),1:length(GroupId),'UniformOutput',false); % cell array where each cell contains cartridge cases fired from a particular gun
    
       
    combsubset = select_unique_sets(10,30,3);
    combsubset1 = select_unique_sets(9,30,3);
    combsubset2 = select_unique_sets(8,30,3);
    combsubset3 = select_unique_sets(7,30,3);
    
    Y=cellfun(@(y)size(y,1), T);
  enrol_data_f=[]; enrol_labs_f=[];
    for b=1:30
        mask=arrayfun(@(y)y==10,Y);
        T1(mask)=cellfun(@(y) y(combsubset(b,:),:), T(mask),'UniformOutput',false); %set of 1st 3 cartridge cases-shuffled - not in order
        mask1=arrayfun(@(y)y==9,Y);
        T1(mask1)=cellfun(@(y) y(combsubset1(b,:),:), T(mask1),'UniformOutput',false);
        mask2=arrayfun(@(y)y==8,Y);
        T1(mask2)=cellfun(@(y) y(combsubset2(b,:),:), T(mask2),'UniformOutput',false);
        mask3=arrayfun(@(y)y==7,Y);
        T1(mask3)=cellfun(@(y) y(combsubset3(b,:),:), T(mask3),'UniformOutput',false);
        T1_m=cellfun(@(y) mean(y,1), T1,'UniformOutput',false);
        AB=cat(1,T1_m{:});
        enrol_labs_f=[enrol_labs_f;GroupId];
        enrol_data_f=[enrol_data_f;AB];
    end
        
        
        
%         Y=cellfun(@(y)size(y,1), T);
%         
%         mask=arrayfun(@(y)y>9,Y); % this is the if-else condition - if no. of cart cases for a particular gun is greater than 9, then take only from 7 :9, if <=9, take from 7 :end
%         T3=cellfun(@(y) y(7:end,:), T,'UniformOutput',false);
%         T3(mask)=cellfun(@(x) x(7:9,:) , T(mask),'UniformOutput',false);
%         T3_m=cellfun(@(y)mean(y,1), T3,'UniformOutput',false);
%         
%         % T1, T2 and T3 are the enrolment sets for a given test datapoint
%         AB=cat(1,T1_m{:});
%         AB1=cat(1,T2_m{:});
%         AB2=cat(1,T3_m{:});
%         
%         enrol_data_f=[AB;AB1;AB2];
%         enrol_labs_f=[GroupId;GroupId;GroupId];
        
        
        parfor (g=1:size(enrol_data_f,1),29)
            scores = two_cov_verification(model, enrol_data_f(g,:), test_data);
            plda_scores(dd,g)=scores;
            if test_labels==enrol_labs_f(g)
                L_test(dd,g)=1;
            else
                L_test(dd,g)=0;
            end
            
            gun_pair1(dd,g)=enrol_labs_f(g);
            gun_pair2(dd,g)=test_labels;
        end
    end
 
elseif opt==3 % this is for 1v9
    for dd=1:size(entest_data,1)
        % test dataset and labels
        test_data=entest_data(dd,:);
        test_labels=entest_labels(dd);
        
        idxT=setdiff(1:size(entest_data,1),dd);
        enrol_data_all=entest_data(idxT,:);
        enrol_labels_all=entest_labels(idxT);
        
        
        parfor (g=1:length(uEntestLabs),29)  % the unique different guns
            idE=find_logical(enrol_labels_all==uEntestLabs(g));
            enrol_da=enrol_data_all(idE,:);
            
            enrol_data=mean(enrol_da,1); % mean for a particular gun % 1 datapoint
            enrol_labels=uEntestLabs(g);
            
            scores = two_cov_verification(model, enrol_data, test_data);
            plda_scores(dd,g)=scores;
            
            if test_labels==enrol_labels
                L_test(dd,g)=1;
            else
                L_test(dd,g)=0;
            end
            
            gun_pair1(dd,g)=enrol_labels;
            gun_pair2(dd,g)=test_labels;
        end
    end
 end

[r c]=size(plda_scores);
Plda_scores=reshape(plda_scores,[r*c 1]);
Lab_test=reshape(L_test,[r*c 1]);

Gun_p1=reshape(gun_pair1,[r*c 1]);
Gun_p2=reshape(gun_pair2,[r*c 1]);

Gun_pairs=[Gun_p1 Gun_p2];



end

